library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity pong_top is 
  port (
    KEY:        in std_logic_vector(3 downto 0);
    CLOCK_50:   in std_logic;
    VGA_R:      out unsigned(3 downto 0);
    VGA_G:      out unsigned(3 downto 0);
    VGA_B:      out unsigned(3 downto 0);
    VGA_HS:     out std_logic;
    VGA_VS:     out std_logic
  );
end; 

architecture struct of pong_top is

  component pixelcounter is 
    port (
      reset_ni:       in std_logic; -- Reset is active low
      clk_i:          in std_logic;
      en_i:           in std_logic; -- Count when en_i is '1'
      pixelh_o:       out unsigned(9 downto 0);
      pixelv_o:       out unsigned(9 downto 0)
    );
  end component; 

  component clockengen is 
    port (
      reset_ni:       in std_logic; -- Reset is active low
      clk_i:          in std_logic;
      en_o:           out std_logic
    );
  end component; 

  component vgasync is 
    port (
      reset_ni:   in std_logic;
      clk_i:      in std_logic;
      pixelh_i:   in unsigned(9 downto 0);  -- horizontal pixel counter
      pixelv_i:   in unsigned(9 downto 0);  -- vertical pixel counter
      vga_hs_o:   out std_logic;
      vga_vs_o:   out std_logic
    );
  end component; 

  component testbild is 
    port (
      reset_ni:   in std_logic;
      clk_i:      in std_logic;
      pixelh_i:   in unsigned(9 downto 0);  -- horizontal pixel counter
      pixelv_i:   in unsigned(9 downto 0);  -- vertical pixel counter
      vga_r_o:    out unsigned(3 downto 0);
      vga_g_o:    out unsigned(3 downto 0);
      vga_b_o:    out unsigned(3 downto 0)
    );
  end component; 

  signal en : std_logic;
  signal pixelh, pixelv : unsigned(9 downto 0);
begin

  pixelcounter_i0 : pixelcounter
    port map (
      reset_ni => KEY(0),
      clk_i    => CLOCK_50, 
      en_i     => en,
      pixelh_o => pixelh, 
      pixelv_o => pixelv);

  clockengen_i0 : clockengen
    port map (
      reset_ni => KEY(0),
      clk_i    => CLOCK_50, 
      en_o     => en);

  vgasync_i0 : vgasync
    port map (
      reset_ni => KEY(0),
      clk_i    => CLOCK_50,
      pixelh_i => pixelh,
      pixelv_i => pixelv,
      vga_hs_o => VGA_HS,
      vga_vs_o => VGA_VS);

  testbild_i0 : testbild
    port map (
      reset_ni => KEY(0),
      clk_i    => CLOCK_50,
      pixelh_i => pixelh,
      pixelv_i => pixelv,
      vga_r_o  => VGA_R,
      vga_g_o  => VGA_G,
      vga_b_o  => VGA_B);
			   
end; -- architecture


