library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

-- This unit generates the horizontal and vertical 
-- VGA Sync signal taking pixel counters as inputs. 

-- VGA Video Timing Generator
-- The VGA signal has one analog signal for each
-- color: Red, Green, Blue (RGB)
-- For synchronization one vertical and one horizontal sync signal
-- is needed. 
-- At the end of each line the horizontial sync is activated. 
-- At the end of the last line, the vertical sync is activated. 
-- Before and after the sync signals, the
-- video signal is off for historical reasons. Old monitors
-- used that time to move the electron beam to the next line
-- or back to upper left corner after the last line was drawn. 
-- These times are called "Back porch" and "Front Porch" times.
-- "Front Porch" - Time before the sync signal
-- "Back Porch"  - Time after the sync signal 
-- 
-- Horizonal Timing
--
-- Horizonal Dots         640        
-- Vertical Scan Lines    480
-- Horiz. Sync Polarity   NEG
--                        us        pix
-- A (us)                 31.77     800  Scanline time
-- B (us)                 3.77       96  Sync pulse length
-- C (us)                 1.89       48  Back porch
-- D (us)                 25.17     640  Active video time
-- E (us)                 0.94       16  Front porch
-- => 16 + 96 + 48 = 160 (blank time) 

-- Vertical Timing (in lines) 
--                                  lines
-- A                                525 Total
-- B                                  2 Sync pulse length
-- C                                 33 Back porch
-- D                                480 Active Video
-- E                                 10 Front Porch   
--  
--         ______________________          ________
--________|        VIDEO         |________| VIDEO (next line)
--    |-C-|----------D-----------|-E-|
--__   ______________________________   ___________
--  |_|                              |_|
--  |B|
--  |---------------A----------------|



entity vgasync is 
  port (
    reset_ni:   in std_logic;
    clk_i:      in std_logic;
    pixelh_i:   in unsigned(9 downto 0);  -- horizontal pixel counter
    pixelv_i:   in unsigned(9 downto 0);  -- vertical pixel counter
    vga_hs_o:   out std_logic;
    vga_vs_o:   out std_logic
  );
end; 

architecture rtl of vgasync is
begin
			   
end; -- architecture


