library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity pong_tb is
end; 

architecture beh of pong_tb is

  component pong_top 
  port (
    KEY:        in std_logic_vector(3 downto 0);
    CLOCK_50:   in std_logic;
    VGA_R:      out unsigned(3 downto 0);
    VGA_G:      out unsigned(3 downto 0);
    VGA_B:      out unsigned(3 downto 0);
    VGA_HS:     out std_logic;
    VGA_VS:     out std_logic
    );
  end component;

  signal clk : std_logic := '0';
  signal reset : std_logic_vector(3 downto 0) := "0000"; 
  signal VGA_R, VGA_G, VGA_B : unsigned(3 downto 0);
  signal VGA_HS, VGA_VS : std_logic;

begin
  pong_top_i0 : pong_top
    port map (
      CLOCK_50            => clk,
      KEY                 => reset,
      VGA_R               => VGA_R,
      VGA_G               => VGA_G,
      VGA_B               => VGA_B,
      VGA_HS              => VGA_HS,
      VGA_VS              => VGA_VS);

  reset <= "1111" after 500 ns;
  clk <= not clk after 50 ns;

end; -- architecture
