library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

-- Compute the ball position from a speed vector. 
-- The new ball position is computed for every new frame, i.e. 
-- every 16ms. 
-- To identify the new frame, the vsync signal is used. 
-- A ball moving over the screen in horizontal direction in 5s
-- will need 300 frames for this. Therefore, the speed would be 
-- 2,13 pixel/frame. The selected input range for the vector is
-- 1 to 15 pixels per frame

entity vector is 
  port (
    reset_ni:   in std_logic;
    clk_i:      in std_logic;
    restart_i:  in std_logic;              -- This will restart from the start position
    posx_o:     out unsigned(9 downto 0);  -- Position of upper left corner
    posy_o:     out unsigned(9 downto 0);
    vsync_ni:   in std_logic;              -- 
    vech_i:     in signed(4 downto 0);  -- horizontal speed vector
    vecv_i:     in signed(4 downto 0)  -- vertical speed vector
  );
end; 

architecture rtl of vector is
begin
			   
end; -- architecture


