library ieee;
use ieee.std_logic_1164.all;

-- Counter with synchronous reset and enable

entity counter is 
  generic (
    width : integer);
  port (
    clk_i :           in std_ulogic;
    res_n :           in std_ulogic;  -- Asynchronous Reset
    en_i  :           in std_ulogic;
    sync_res_ni:      in std_ulogic;  -- Active low synchronous reset
    cnt_o :          out std_ulogic_vector(width-1 downto 0)
  );
end; 

architecture struct of counter is

 constant zero : std_ulogic_vector(width-1 downto 0) := (others => '0'); 
 constant one  : std_ulogic_vector(width-1 downto 0) := zero(width-1 downto 1) & '1' ; 

begin
    
end; -- architecture


