library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

-- Adder with configurable width

entity adder is 
  generic (
    width : integer);
  port (
    a_i :           in std_ulogic_vector(width-1 downto 0);
    b_i :           in std_ulogic_vector(width-1 downto 0);
    y_o :           out std_ulogic_vector(width-1 downto 0)
  );
end; 

architecture rtl of adder is
  signal a, b, y : unsigned(width-1 downto 0); 
begin

  a <= unsigned(a_i);
  b <= unsigned(b_i);
  y <= a + b;
  y_o <= std_ulogic_vector(y); 
  
end; -- architecture


