library ieee;
use ieee.std_logic_1164.all;

-- Counter with synchronous reset and enable

entity counter is 
  generic (
    width : integer);
  port (
    clk_i :           in std_ulogic;
    res_n :           in std_ulogic;  -- Asynchronous Reset
    en_i  :           in std_ulogic;
    sync_res_ni:      in std_ulogic;  -- Active low synchronous reset
    cnt_o :          out std_ulogic_vector(width-1 downto 0)
  );
end; 

architecture struct of counter is

 component adder is 
  generic (
    width : integer);
  port (
    a_i :           in std_ulogic_vector(width-1 downto 0);
    b_i :           in std_ulogic_vector(width-1 downto 0);
    y_o :           out std_ulogic_vector(width-1 downto 0)
  );
 end component; 

 component reg is 
  generic (
    width : integer);
  port (
    res_n:          in std_ulogic; -- Reset is active low
    clk_i:          in std_ulogic;
    d_i :           in std_ulogic_vector(width-1 downto 0);
    q_o :           out std_ulogic_vector(width-1 downto 0)
  );
 end component; 
 
 component mux is 
  generic (
    width : integer);
  port (
    a_i :           in std_ulogic_vector(width-1 downto 0);
    b_i :           in std_ulogic_vector(width-1 downto 0);
    s_i :           in std_ulogic; 
    y_o :           out std_ulogic_vector(width-1 downto 0)
  );
 end component;

 signal cnt, d, m0, m1: std_ulogic_vector(width-1 downto 0);  

 constant zero : std_ulogic_vector(width-1 downto 0) := (others => '0'); 
 constant one  : std_ulogic_vector(width-1 downto 0) := zero(width-1 downto 1) & '1' ; 

begin

  reg_i0 : reg
  generic map (
    width => width)
  port map (
    clk_i => clk_i,
    res_n => res_n,
    d_i   => d,
    q_o   => cnt  
  ); 

  mux_i0 : mux
  generic map (
    width => width)
  port map (
    a_i => cnt,
    b_i => m0,
    s_i => en_i,
    y_o => d);
    
  mux_i1 : mux
  generic map (
    width => width)
  port map (
    a_i => zero,
    b_i => m1,
    s_i => sync_res_ni,
    y_o => m0);

  add_i0 : adder
  generic map (
    width => width)
  port map (
    a_i => cnt,
    b_i => one,
    y_o => m1); 

  cnt_o  <= cnt; 
    
end; -- architecture


