library ieee;
use ieee.std_logic_1164.all;

-- Multiplexer with configurable data width

entity mux4 is 
  generic (
    width : integer);
  port (
    d0_i :           in std_ulogic_vector(width-1 downto 0);
    d1_i :           in std_ulogic_vector(width-1 downto 0);
    d2_i :           in std_ulogic_vector(width-1 downto 0);
    d3_i :           in std_ulogic_vector(width-1 downto 0);
    s_i :            in std_ulogic_vector(1 downto 0); 
    y_o :            out std_ulogic_vector(width-1 downto 0)
  );
end; 

architecture struct of mux4 is

  component mux is 
    generic (
      width : integer);
    port (
      a_i :           in std_ulogic_vector(width-1 downto 0);
      b_i :           in std_ulogic_vector(width-1 downto 0);
      s_i :           in std_ulogic; 
      y_o :           out std_ulogic_vector(width-1 downto 0)
    );
  end component;
  
  signal s1, s2 : std_ulogic_vector(width-1 downto 0); 
 
begin


       
end; -- architecture


