library ieee;
use ieee.std_logic_1164.all;

-- Multiplexer with configurable data width

entity mux is 
  generic (
    width : integer);
  port (
    a_i :           in std_ulogic_vector(width-1 downto 0);
    b_i :           in std_ulogic_vector(width-1 downto 0);
    s_i :           in std_ulogic; 
    y_o :           out std_ulogic_vector(width-1 downto 0)
  );
end; 

architecture rtl of mux is 
begin
  y_o <= b_i when s_i = '1' else a_i;     
end; -- architecture


