library ieee;
use ieee.std_logic_1164.all;

-- Register with enable

entity regen is 
  generic (
    width : integer);
  port (
    res_n:          in std_ulogic; -- Reset is active low
    clk_i:          in std_ulogic;
    en_i :          in std_ulogic;
    d_i :           in std_ulogic_vector(width-1 downto 0);
    q_o :           out std_ulogic_vector(width-1 downto 0)
  );
end; 

architecture struct of regen is

 component reg is 
  generic (
    width : integer);
  port (
    res_n:          in std_ulogic; -- Reset is active low
    clk_i:          in std_ulogic;
    d_i :           in std_ulogic_vector(width-1 downto 0);
    q_o :           out std_ulogic_vector(width-1 downto 0)
  );
 end component; 

 component mux is 
  generic (
    width : integer);
  port (
    a_i :           in std_ulogic_vector(width-1 downto 0);
    b_i :           in std_ulogic_vector(width-1 downto 0);
    s_i :           in std_ulogic; 
    y_o :           out std_ulogic_vector(width-1 downto 0)
  );
 end component;

 signal dreg, qreg : std_ulogic_vector(width-1 downto 0);  

begin

  reg_i0 : reg
  generic map (
    width => width)
  port map (
    clk_i => clk_i,
    res_n => res_n,
    d_i   => dreg,
    q_o   => qreg  
  ); 

  mux_i0 : mux
  generic map (
    width => width)
  port map (
    a_i => qreg,
    b_i => d_i,
    s_i => en_i,
    y_o => dreg);
	 
  q_o <= qreg; 
        
end; -- architecture


