library ieee;
use ieee.std_logic_1164.all;

-- Register with configurable width

entity reg is 
  generic (
    width : integer);
  port (
    res_n:          in std_ulogic; -- Reset is active low
    clk_i:          in std_ulogic;
    d_i :           in std_ulogic_vector(width-1 downto 0);
    q_o :           out std_ulogic_vector(width-1 downto 0)
  );
end; 

architecture rtl of reg is
begin

  reg_p: process(clk_i, res_n)
  begin
    if res_n = '0' then
      q_o <= (others => '0');
    elsif rising_edge(clk_i) then
      q_o <= d_i;  
    end if; -- rising_edge
  end process; 
  
end; -- architecture


