library ieee;
use ieee.std_logic_1164.all;

-- SYNC generator

entity syncgen is 
  generic (
    active_cnt_g : std_ulogic_vector(9 downto 0);
    fp_cnt_g     : std_ulogic_vector(9 downto 0); 
    sync_cnt_g   : std_ulogic_vector(9 downto 0); 
    bp_cnt_g     : std_ulogic_vector(9 downto 0)
  ); 
  port (
    clk_i :         in std_ulogic;
    res_n :         in std_ulogic;
    en_i  :         in std_ulogic;
    sync_o :        out std_ulogic;
    done_o:         out std_ulogic; 
    cnt_o:          out std_ulogic_vector(9 downto 0); 
    active_o:       out std_ulogic 
  );
end; 

architecture struct of syncgen is

component synccnt is 
  generic (
    active_cnt_g : std_ulogic_vector(9 downto 0);
    fp_cnt_g     : std_ulogic_vector(9 downto 0); 
    sync_cnt_g   : std_ulogic_vector(9 downto 0); 
    bp_cnt_g     : std_ulogic_vector(9 downto 0)
  );  
  port (
    clk_i :           in std_ulogic;
    res_n :           in std_ulogic;
    en_i  :           in std_ulogic;
    sel_cmp_i:        in std_ulogic_vector(1 downto 0); 
    cnt_o :          out std_ulogic_vector(9 downto 0); 
    done_o :         out std_ulogic
  );
end component; 

component syncsm is 
  port (
    res_n:           in std_ulogic; -- Reset is active low
    clk_i:           in std_ulogic;
    en_i:            in std_ulogic;
    sel_cmp_o:       out std_ulogic_vector(1 downto 0);
    done_i:          in  std_ulogic;
    active_o:        out std_ulogic; 
    sync_o:          out std_ulogic 
  );
end component;  

signal done, active : std_ulogic; 
signal sel_cmp : std_ulogic_vector(1 downto 0); 

begin

synccnt_i0 : synccnt
generic map (
  active_cnt_g => active_cnt_g, 
  fp_cnt_g     => fp_cnt_g, 
  sync_cnt_g   => sync_cnt_g, 
  bp_cnt_g     => bp_cnt_g
) 
port map (
  clk_i         => clk_i,
  res_n         => res_n,
  en_i          => en_i,
  sel_cmp_i     => sel_cmp,
  cnt_o         => cnt_o, 
  done_o        => done); 

syncsm_i0 : syncsm
port map (
  clk_i         => clk_i,
  res_n         => res_n,
  en_i          => en_i,
  sel_cmp_o     => sel_cmp,  
  done_i        => done,
  active_o      => active,
  sync_o        => sync_o);   
  
  done_o <= active and done and en_i;   
  active_o <= active; 
    
end; -- architecture


