library ieee;
use ieee.std_logic_1164.all;

entity vgatop_tb is 
end; 

architecture beh of vgatop_tb is

component vgatop is 
  port (
    clk_i : in std_ulogic;
    res_n : in std_ulogic;
    vga_r_o:      out std_ulogic_vector(3 downto 0);
    vga_g_o:      out std_ulogic_vector(3 downto 0);
    vga_b_o:      out std_ulogic_vector(3 downto 0);
    vga_hs_o:     out std_ulogic;
    vga_vs_o:     out std_ulogic
  );
end component;  

  signal res_n, clk : std_ulogic; 

  signal vga_r, vga_g, vga_b : std_ulogic_vector(3 downto 0); 
  signal vga_hs, vga_vs : std_ulogic; 
 

  SIGNAL clken_p  : boolean := true;

begin

  vgatop_i0 : vgatop
    port map (
      clk_i     => clk,
      res_n     => res_n, 
      vga_r_o   => VGA_R,
      vga_g_o   => VGA_G,
      vga_b_o   => VGA_B,
      vga_hs_o  => VGA_HS,
      vga_vs_o  => VGA_VS); 

  -- 50 MHz 
  -- clock generation 
  clock_p : PROCESS
  BEGIN
    WHILE clken_p LOOP
      clk <= '0'; WAIT FOR 10 ns;
      clk <= '1'; WAIT FOR 10 ns;
    END LOOP;
    WAIT;
  END PROCESS;

  -- initial reset, always necessary at the beginning of a simulation
  reset : res_n <= '0', '1' AFTER 10 ns;

  stimuli_p : PROCESS
  BEGIN

    WAIT UNTIL res_n = '1';            -- wait until asynchronous reset ...
                                        -- ... is deactivated

    wait for 20 ms; 


    clken_p <= false;                   -- switch clock generator off

    WAIT;                               -- suspend proces
  END PROCESS;
      
			   
end; -- architecture


