library ieee;
use ieee.std_logic_1164.all;

entity de1_vgatop is 
  port (
    KEY:        in std_logic_vector(3 downto 0);
    CLOCK_50:   in std_logic;
    GPO_1:      out std_ulogic_vector(35 downto 0); 
    VGA_R:      out std_ulogic_vector(3 downto 0);
    VGA_G:      out std_ulogic_vector(3 downto 0);
    VGA_B:      out std_ulogic_vector(3 downto 0);
    VGA_HS:     out std_logic;
    VGA_VS:     out std_logic
  );
end; 

architecture struct of de1_vgatop is

component vgatop is 
  port (
    clk_i : in std_ulogic;
    res_n : in std_ulogic;
    vga_r_o:      out std_ulogic_vector(3 downto 0);
    vga_g_o:      out std_ulogic_vector(3 downto 0);
    vga_b_o:      out std_ulogic_vector(3 downto 0);
    vga_hs_o:     out std_ulogic;
    vga_vs_o:     out std_ulogic
  );
end component;  

  signal res_n, clk : std_ulogic; 
  signal vga_r_s, vga_g_s, vga_b_s : std_ulogic_vector(3 downto 0);  
  signal vga_hs_s, vga_vs_s : std_ulogic; 
  
begin

  clk <= CLOCK_50; 
  res_n <= KEY(0); 

  vgatop_i0 : vgatop
    port map (
      clk_i     => clk,
      res_n     => res_n, 
      vga_r_o   => vga_r_s,
      vga_g_o   => vga_g_s,
      vga_b_o   => vga_b_s,
      vga_hs_o  => vga_hs_s,
      vga_vs_o  => vga_vs_s); 
      
  VGA_R <= vga_r_s;
  VGA_G <= vga_g_s;
  VGA_B <= vga_b_s;
  VGA_HS <= vga_hs_s;
  VGA_VS <= vga_vs_s; 

  GPO_1(0) <= vga_hs_s;
  GPO_1(1) <= vga_vs_s; 
  GPO_1(5 downto 2) <= vga_r_s;
  GPO_1(9 downto 6) <= vga_g_s; 
  GPO_1(13 downto 10) <= vga_b_s; 
  GPO_1(35 downto 14) <= (others => '0'); 

			   
end; -- architecture


