library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

-- Comparator for two unsigned numbers 
-- a_i >= b_i => ge_o = '1'
-- a_i <  b_i => ge_o = '0'

entity compare is 
  port (
    a_i:             in std_ulogic_vector(11 downto 0);
    b_i:             in std_ulogic_vector(11 downto 0);
    ge_o:            out std_ulogic
  );
end; 

architecture rtl of compare is

begin

  ge_o <= '1' when unsigned(a_i) >= unsigned(b_i) else '0';  
     
end; -- architecture


