-------------------------------------------------------------------------------
-- module     : de1_play
-------------------------------------------------------------------------------
-- author     : Friedrich Beckmann
-- company    : university of applied sciences augsburg
-------------------------------------------------------------------------------
-- description: test the module play on a de1 prototype board
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;

entity de1_play is
  port (
    CLOCK_50 : in  std_ulogic;                    -- 50 mhz clock
    KEY      : in  std_ulogic_vector(1 downto 0); -- key(1..0)
    LEDR     : out std_ulogic_vector(4 downto 0); -- red LED(4..0)
    LEDG     : out std_ulogic_vector(1 downto 0)  -- green LED(1..0)
    );
end de1_play;

architecture structure of de1_play is

  component cntdnmodm
    generic (
      n : natural;
      m : natural);
    port (
      clk_i   : in  std_ulogic;
      rst_ni  : in  std_ulogic;
      en_pi   : in  std_ulogic;
      count_o : out std_ulogic_vector(n-1 downto 0);
      tc_o    : out std_ulogic);
  end component;

  component rising_edge_detector
    port (
      clk_i  : in  std_ulogic;
      rst_ni : in  std_ulogic;
      x_i    : in  std_ulogic;
      rise_o : out std_ulogic);
  end component;

  component play is
  port (clk        : in  std_ulogic;
        rst_n      : in  std_ulogic;
        onesec_i   : in  std_ulogic;
        key_i      : in  std_ulogic;
        led_o      : out std_ulogic_vector(4 downto 0));
  end component;

  signal clk_i    : std_ulogic;
  signal rst_ni   : std_ulogic;
  signal key_inv  : std_ulogic;
  signal key_edge : std_ulogic;

  signal one_second_period : std_ulogic;

begin

  -- connecting clock generator master clock of synchronous system
  clk_i <= CLOCK_50;

  -- connecting asynchronous system reset to digital system
  rst_ni <= KEY(0);
  -- Invert the pushbutton for controlling play 
  key_inv <= not KEY(1);

  LEDG <= not KEY;                      -- pushbutton on green LED
  
  -- Rising Edge Detection for KEY1 
  edge_key : rising_edge_detector
    port map (
      clk_i => clk_i,
      rst_ni => rst_ni,
      x_i    => key_inv,
      rise_o => key_edge);

  -- based on the 50 mhz clock, generates an enable signal of period t = 1 sec
  clock_divider : cntdnmodm
    generic map (
      n => 26,
      m => 50e6)
    port map (
      clk_i   => clk_i,
      rst_ni  => rst_ni,
      en_pi   => '1',                   -- permanently enabled
      count_o => open,                
      tc_o    => one_second_period);

  play_i0 : play
    port map (
      clk      => clk_i,
      rst_n    => rst_ni,
      onesec_i => one_second_period,
      key_i    => key_edge,
      led_o    => LEDR);

end structure;
