library ieee;
use ieee.std_logic_1164.all;

entity t_counter is 
end; 

architecture tbench of t_counter is

component counter is 
  port (
    clk_i :           in std_ulogic;
    res_n :           in std_ulogic;  -- Asynchronous Reset
    en_i  :           in std_ulogic;
    sync_res_ni:      in std_ulogic;  -- Active low synchronous reset
    cnt_o :          out std_ulogic_vector(11 downto 0)
  );
end component; 

  signal res_n, clk : std_ulogic; 

  signal cnt : std_ulogic_vector(11 downto 0); 
  signal sync_res_n, en : std_ulogic;  

  SIGNAL clken_p  : boolean := true;

begin

  counter_i0 : counter
  port map (
    clk_i => clk,
    res_n => res_n,
    en_i  => en, 
    sync_res_ni => sync_res_n, 
    cnt_o    => cnt
  ); 


  -- 50 MHz 
  -- clock generation 
  clock_p : PROCESS
  BEGIN
    WHILE clken_p LOOP
      clk <= '0'; WAIT FOR 10 ns;
      clk <= '1'; WAIT FOR 10 ns;
    END LOOP;
    WAIT;
  END PROCESS;

  -- initial reset, always necessary at the beginning of a simulation
  reset : res_n <= '0', '1' AFTER 10 ns;

  stimuli_p : PROCESS
  BEGIN
    
    en <= '0';
    sync_res_n <= '1'; 

    WAIT UNTIL res_n = '1';            -- wait until asynchronous reset ...
                                        -- ... is deactivated

    wait until falling_edge(clk);     
    wait for 60 ns; 
    
    en <= '1'; 
    
    wait for 100 ns; 
    
    en <= '0'; 
    
    wait for 50 ns; 
    
    sync_res_n <= '0'; 
    
    wait for 50 ns; 
    
    en <= '1'; 
    
    wait for 50 ns; 
    
    sync_res_n <= '1'; 
    
    wait for 1 ms; 

    clken_p <= false;                   -- switch clock generator off

    WAIT;                               -- suspend proces
  END PROCESS;
      
			   
end; -- architecture


