library ieee;
use ieee.std_logic_1164.all;

entity t_synccnt is 
end; 

architecture tbench of t_synccnt is

component synccnt is 
  generic (
    active_cnt_g : std_ulogic_vector(11 downto 0);
    fp_cnt_g     : std_ulogic_vector(11 downto 0); 
    sync_cnt_g   : std_ulogic_vector(11 downto 0); 
    bp_cnt_g     : std_ulogic_vector(11 downto 0)
  );  
  port (
    clk_i :           in std_ulogic;
    res_n :           in std_ulogic;
    en_i  :           in std_ulogic;
    sel_cmp_i:        in std_ulogic_vector(1 downto 0); 
    cnt_o :          out std_ulogic_vector(11 downto 0); 
    done_o :         out std_ulogic
  );
end component; 

  signal res_n, clk : std_ulogic;
  
  signal en, done: std_ulogic; 
  signal sel_cmp : std_ulogic_vector(1 downto 0);  
  signal cnt : std_ulogic_vector(11 downto 0); 

  SIGNAL clken_p  : boolean := true;

begin

synccnt_i0 : synccnt
generic map (
  active_cnt_g => "000000010000", 
  fp_cnt_g     => "000000100000", 
  sync_cnt_g   => "000000001000", 
  bp_cnt_g     => "000001000000"
) 
port map (
  clk_i         => clk,
  res_n         => res_n,
  en_i          => en,
  sel_cmp_i     => sel_cmp,
  cnt_o         => cnt, 
  done_o        => done); 

  -- 50 MHz 
  -- clock generation 
  clock_p : PROCESS
  BEGIN
    WHILE clken_p LOOP
      clk <= '0'; WAIT FOR 10 ns;
      clk <= '1'; WAIT FOR 10 ns;
    END LOOP;
    WAIT;
  END PROCESS;

  -- initial reset, always necessary at the beginning of a simulation
  reset : res_n <= '0', '1' AFTER 10 ns;

  stimuli_p : PROCESS
  BEGIN
    
    en <= '0'; 
    sel_cmp <= "00"; 

    WAIT UNTIL res_n = '1';            -- wait until asynchronous reset ...
                                        -- ... is deactivated

    wait until falling_edge(clk); 
    wait for 100 ns; 
    en <= '1';
    wait for 1 us; 
    sel_cmp <= "01";
    wait for 1 us; 
    sel_cmp <= "10";    
    wait for 1 us; 
    sel_cmp <= "11";    
    wait for 1 us; 

    clken_p <= false;                   -- switch clock generator off

    WAIT;                               -- suspend proces
  END PROCESS;
      
			   
end; -- architecture


