library ieee;
use ieee.std_logic_1164.all;

entity t_vgatop is 
end; 

architecture tbench of t_vgatop is

component vgatop is 
  port (
    clk_i : in std_ulogic;
    res_n : in std_ulogic;
    vga_r_o:      out std_ulogic_vector(3 downto 0);
    vga_g_o:      out std_ulogic_vector(3 downto 0);
    vga_b_o:      out std_ulogic_vector(3 downto 0);
    vga_hs_o:     out std_ulogic;
    vga_vs_o:     out std_ulogic
  );
end component;  

  signal res_n, clk : std_ulogic; 

  signal vga_r, vga_g, vga_b : std_ulogic_vector(3 downto 0); 
  signal vga_hs, vga_vs : std_ulogic; 
 

  SIGNAL clken_p  : boolean := true;

begin

  vgatop_i0 : vgatop
    port map (
      clk_i     => clk,
      res_n     => res_n, 
      vga_r_o   => VGA_R,
      vga_g_o   => VGA_G,
      vga_b_o   => VGA_B,
      vga_hs_o  => VGA_HS,
      vga_vs_o  => VGA_VS); 

  -- 50 MHz 
  -- clock generation 
  clock_p : process
  begin
    while clken_p loop
      clk <= '0'; wait for 10 ns;
      clk <= '1'; wait for 10 ns;
    end loop;
    wait;
  end process;

  -- initial reset, always necessary at the beginning of a simulation
  reset : res_n <= '0', '1' AFTER 10 ns;

  stimuli_p : process
  begin

    wait until res_n = '1';            -- wait until asynchronous reset ...
                                        -- ... is deactivated

    wait for 60 ms; 


    clken_p <= false;                   -- switch clock generator off

    wait;                               -- suspend proces
  end process;
      
			   
end; -- architecture


