library ieee;
use ieee.std_logic_1164.all;

entity vgatop is 
  port (
    clk_i : in std_ulogic;
    res_n : in std_ulogic;
    vga_r_o:      out std_ulogic_vector(3 downto 0);
    vga_g_o:      out std_ulogic_vector(3 downto 0);
    vga_b_o:      out std_ulogic_vector(3 downto 0);
    vga_hs_o:     out std_ulogic;
    vga_vs_o:     out std_ulogic
  );
end; 

architecture struct of vgatop is

  component clockengen is 
    port (
      res_n:          in std_ulogic; -- Reset is active low
      clk_i:          in std_ulogic;
      en_o:           out std_ulogic
    );
  end component; 

  component syncgen is 
    generic (
      active_cnt_g : std_ulogic_vector(11 downto 0);
      fp_cnt_g     : std_ulogic_vector(11 downto 0); 
      sync_cnt_g   : std_ulogic_vector(11 downto 0); 
      bp_cnt_g     : std_ulogic_vector(11 downto 0)
    ); 
    port (
      clk_i :         in std_ulogic;
      res_n :         in std_ulogic;
      en_i  :         in std_ulogic;
      sync_o :       out std_ulogic;
      done_o:         out std_ulogic;
      cnt_o:          out std_ulogic_vector(11 downto 0);  
      active_o:       out std_ulogic  
    );
  end component;

  component bildgen is 
    port (
      pixcnt_i:      in std_ulogic_vector(11 downto 0);
      linecnt_i:     in std_ulogic_vector(11 downto 0);
      active_i:      in std_ulogic; 
      vga_r_o:      out std_ulogic_vector(3 downto 0);
      vga_g_o:      out std_ulogic_vector(3 downto 0);
      vga_b_o:      out std_ulogic_vector(3 downto 0)
    );
  end component; 

  signal en, done, hactive, vactive, active: std_ulogic;  
  signal pixcnt : std_ulogic_vector(11 downto 0); 
  signal linecnt: std_ulogic_vector(11 downto 0); 

begin

  clockengen_i0 : clockengen
    port map (
      res_n    => res_n,
      clk_i    => clk_i, 
      en_o     => en);

  hsyncgen_i0 : syncgen
    generic map (
      active_cnt_g => "000000001111",
      fp_cnt_g     => "000000000111",
      sync_cnt_g   => "000000000011",
      bp_cnt_g     => "000000000001" 
    ) 
    port map (
      clk_i    => clk_i,
      res_n    => res_n, 
      en_i     => en,
      sync_o   => vga_hs_o,
      done_o   => done,
      cnt_o    => pixcnt,  
      active_o => hactive); 

  vsyncgen_i0 : syncgen
    generic map (
      active_cnt_g => "000000001111", 
      fp_cnt_g     => "000000000111", 
      sync_cnt_g   => "000000000011", 
      bp_cnt_g     => "000000000001"  
    ) 
    port map (
      clk_i    => clk_i,
      res_n    => res_n, 
      en_i     => done,
      sync_o   => vga_vs_o,
      done_o   => open,
      cnt_o    => linecnt,  
      active_o => vactive); 

  active <= hactive and vactive; 

  bildgen_i0 : bildgen
    port map (
      pixcnt_i   => pixcnt,
      linecnt_i  => linecnt, 
      active_i   => active, 
      vga_r_o    => vga_r_o,
      vga_g_o    => vga_g_o, 
      vga_b_o    => vga_b_o); 
      			   
end; -- architecture


