-------------------------------------------------------------------------------
-- Module     : binto7segment
-------------------------------------------------------------------------------
-- Author     : Johann Faerber
-- Company    : University of Applied Sciences Augsburg
-------------------------------------------------------------------------------
-- Description: binary-to-7-segment decoder
--              function modelled as a truth table
--              using a case statement in a process
--              segments get illuminated by a low-active signal
-------------------------------------------------------------------------------
-- Revisions  : see end of file
-------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

ENTITY binto7segment IS
  PORT (bin_i      : IN  std_ulogic_vector(3 DOWNTO 0);
        segments_o : OUT std_ulogic_vector(6 DOWNTO 0)
        );
END binto7segment;

ARCHITECTURE truthtable OF binto7segment IS

  -- seven-segment positions
  -- 
  -- segment positions    input vector index     segment name
  --      a                      0            =>     a
  --     ---                     1            =>     b
  --  f |   | b                  2            =>     c
  --     ---   <- g              3            =>     d 
  --  e |   | c                  4            =>     e 
  --     ---                     5            =>     f 
  --      d                      6            =>     g

BEGIN

  decoder_p : PROCESS (bin_i)
  BEGIN                          -- index        number displayed
    CASE bin_i IS                -- 6543210 
      WHEN "0000" => segments_o <= "1000000";    -- 0
      WHEN "0001" => segments_o <= "1111001";    -- 1
      WHEN "0010" => segments_o <= "0100100";    -- 2
      WHEN "0011" => segments_o <= "0110000";    -- 3
      WHEN "0100" => segments_o <= "0011001";    -- 4
      WHEN "0101" => segments_o <= "0010010";    -- 5
      WHEN "0110" => segments_o <= "0000010";    -- 6
      WHEN "0111" => segments_o <= "1111000";    -- 7
      WHEN "1000" => segments_o <= "0000000";    -- 8
      WHEN "1001" => segments_o <= "0010000";    -- 9
      WHEN "1010" => segments_o <= "0001000";    -- A
      WHEN "1011" => segments_o <= "0000011";    -- b
      WHEN "1100" => segments_o <= "1000110";    -- C
      WHEN "1101" => segments_o <= "0100001";    -- d
      WHEN "1110" => segments_o <= "0000110";    -- E
      WHEN "1111" => segments_o <= "0001110";    -- F
      WHEN OTHERS => segments_o <= "XXXXXXX";
    END CASE;
  END PROCESS decoder_p;

END truthtable;
-------------------------------------------------------------------------------
-- Revisions:
-- ----------
-- $Id:$
-------------------------------------------------------------------------------

