%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% simulink_basics_ex4_ini.m
%
% Exercise to lessons MATLAB/Simulink 
% Simulink Basics
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Configuration Parameters
% Fixed step solver
Tstop   = 10;                   % Stop time
Tsample = 0.1;                  % Fixed-step size
T       = (0:Tsample:Tstop)';   % Simulation time

% Intitialization of vectors A and B 
siminA = [ T (mod(T,2)>1) ];
siminB = [ T (mod(T,2)>1.5) ];

% Plot vectors A and B
subplot(211) 
    plot(T,siminA(:,2))
    axis([0 Tstop 0 1.1]) 
subplot(212)
    plot(T,siminB(:,2))
    axis([0 Tstop 0 1.1]) 
