%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% simulink_systems_ex5.m
%
% Exercise to lessons MATLAB/Simulink 
% Simulink Systems
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
simulink_systems_ex4

[AA,BB,CC,DD] = linmod2('simulink_systems_ex4');
sys=ss(AA,BB,CC,DD)

% Generate a Input step signal u at 0.1 with the same length
% as the outut signal of Simulink model simulink_systems_ex4.mdl, 
% if u and y are set as Test Points with Signal Properties. 

sim('simulink_systems_ex4')
Tvek = linspace(min(logsout.u.Time),max(logsout.u.Time),length(logsout.u.Time))' ;
u = double(Tvek>=0.1) ;
[y,t] = lsim(sys,u,Tvek);

figure
subplot(311) , title('Linearised Model')
    hold on
    plot(t,u,'--')
    plot(t,y)
subplot(312) , title('Simulink Model')
    hold on
    plot(logsout.u.Time,logsout.u.Data,'--')
    plot(logsout.y.Time,logsout.y.Data)
subplot(313) , title('Error')
    hold on
    plot(logsout.y.Time,logsout.y.Data-y)
