/*Quellcode der C MEX S-Funktion pt1sfun.c */
/*
  Wird vom SIMULINK-File pt1fun.mdl im S-Function-Block
  verwendet und bildet das dynamische Verhalten eines
  PT1-Gliedes nach. Die Zeitkonstante wird im 
  S_Function-Block als Parameter bergeben. Sie mu daher
  im vorher im Workspace im einem Wert belegt werden.
*/



#define S_FUNCTION_NAME  pt1sfun
#define S_FUNCTION_LEVEL 2

#include "simstruc.h"

#define U(element) (*uPtrs[element])  /* Pointer to Input Port0 */

#define ZEITKONSTANTE_IDX 0
#define ZEITKONSTANTE_PARAM(S) ssGetSFcnParam(S,ZEITKONSTANTE_IDX)

#define NPARAMS 1

/*====================*
 * S-function methods *
 *====================*/

#define MDL_CHECK_PARAMETERS
#if defined(MDL_CHECK_PARAMETERS) && defined(MATLAB_MEX_FILE)
  /* Function: mdlCheckParameters =============================================
   * Abstract:
   *    Validate our parameters to verify they are okay.
   */
  static void mdlCheckParameters(SimStruct *S)
  {
      /* Check 1st parameter: time constant */
      {
              if (mxGetNumberOfElements(ZEITKONSTANTE_PARAM(S)) > 1)  
           {
              ssSetErrorStatus(S,"Der Parameter ZEITKONSTANTE mu eingetragen werden" 
                                  "und skalar sein");
              return;
           }
     }
  }
#endif /* MDL_CHECK_PARAMETERS */


/* Function: mdlInitializeSizes ===============================================
 * Abstract:
 *    The sizes information is used by Simulink to determine the S-function
 *    block's characteristics (number of inputs, outputs, states, etc.).
 */
static void mdlInitializeSizes(SimStruct *S)
{
    ssSetNumSFcnParams(S, NPARAMS);  /* Number of expected parameters */
   #if defined(MATLAB_MEX_FILE)
    if (ssGetNumSFcnParams(S) == ssGetSFcnParamsCount(S)) {
        mdlCheckParameters(S);
        if (ssGetErrorStatus(S) != NULL) {
            return;
        }
    } else {
        return; /* Parameter mismatch will be reported by Simulink */
    }
  #endif
 
    ssSetNumContStates(S, 1);
    ssSetNumDiscStates(S, 0);

    if (!ssSetNumInputPorts(S, 1)) return;
    ssSetInputPortWidth(S, 0, 1);
    ssSetInputPortDirectFeedThrough(S, 0, 1);

    if (!ssSetNumOutputPorts(S, 1)) return;
    ssSetOutputPortWidth(S, 0, 1);

    ssSetNumSampleTimes(S, 1);
    ssSetNumRWork(S, 0);
    ssSetNumIWork(S, 0);
    ssSetNumPWork(S, 0);
    ssSetNumModes(S, 0);
    ssSetNumNonsampledZCs(S, 0);

    ssSetOptions(S, 0);
}



/* Function: mdlInitializeSampleTimes =========================================
 * Abstract:
 *    S-function is comprised of only continuous sample time elements
 */
static void mdlInitializeSampleTimes(SimStruct *S)
{
    ssSetSampleTime(S, 0, CONTINUOUS_SAMPLE_TIME);
    ssSetOffsetTime(S, 0, 0.0);

}

#define MDL_INITIALIZE_CONDITIONS   /* Change to #undef to remove function */
/* Function: mdlInitializeConditions ========================================
 * Abstract:
 *    Initialize continuous states to zero
 */
  static void mdlInitializeConditions(SimStruct *S)
  { 
    int_T i;
    real_T *x0 = ssGetContStates(S);
    int_T contstates = ssGetNumContStates(S);

    for(i = 0; i < contstates; i++){
    *x0++ = 0.0;
    }
  }

/* Function: mdlOutputs =======================================================
 * Abstract:
 *    In this function, you compute the outputs of your S-function
 *    block. Generally outputs are placed in the output vector, ssGetY(S).
 */
static void mdlOutputs(SimStruct *S, int_T tid)
{ 
    real_T            *y    = ssGetOutputPortRealSignal(S,0);
    real_T            *x    = ssGetContStates(S);
    InputRealPtrsType uPtrs = ssGetInputPortRealSignalPtrs(S,0);
 
    y[0] = x[0];
    
}


#define MDL_DERIVATIVES  /* Change to #undef to remove function */
/* Function: mdlDerivatives =================================================
 * Abstract:
 *      Calculate state-space derivatives
 */  static void mdlDerivatives(SimStruct *S)
  {  
    real_T            *dx      = ssGetdX(S);
    real_T            *x       = ssGetContStates(S);
    InputRealPtrsType uPtrs    = ssGetInputPortRealSignalPtrs(S,0);
    real_T            *tcpr    = mxGetPr(ZEITKONSTANTE_PARAM(S));

    dx[0] = (-1/tcpr[0]) * x[0] + (1/tcpr[0]) * U(0);
  }


/* Function: mdlTerminate =====================================================
 * Abstract:
 *    No termination needed, but we are required to have this routine.
 */
static void mdlTerminate(SimStruct *S)
{
}

/*=============================*
 * Required S-function trailer *
 *=============================*/

#ifdef  MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */
#include "simulink.c"      /* MEX-file interface mechanism */
#else
#include "cg_sfun.h"       /* Code generation registration function */
#endif
