% Quellcode der M-File S-Funktion pt1sfun.m 
%
function [sys,x0,str,ts] = pt1sfun(t,x,u,flag,T)
% PT1SFUN modelliert das Verhalten eines PT1-Gliedes. 
% Die Zeitkonstante T wird als Parameter aus dem
% S-Function Block eingelesen und taucht daher
% im Parametersatz der Kopfzeile auf.


% Definition des zugehoerigen Zustandssystems:
A = [-1/T];               % Zustandsmatrix (hier skalar)
B = [ 1/T];               % Eingangsmatrix (hier skalar)
C = [ 1  ];               % Ausgangsmatrix (hier skalar)
D = [ 0  ];               % Durchschaltmatrix (hier skalar und
                            % gleich Null, da sich beim PT1
                            % der Eingang nicht direkt auf
                            % den Ausgang auswirkt.
switch flag,

  %%%%%%%%%%%%%%%%%%
  % Initialization %
  %%%%%%%%%%%%%%%%%%
  case 0,
    [sys,x0,str,ts]=mdlInitializeSizes(A,B,C,D);

  %%%%%%%%%%%%%%%
  % Derivatives %
  %%%%%%%%%%%%%%%
  case 1,
    sys=mdlDerivatives(t,x,u,A,B,C,D);

  %%%%%%%%%%%
  % Outputs %
  %%%%%%%%%%%
  case 3,
    sys=mdlOutputs(t,x,u,A,B,C,D);
    
 % Nicht verwendete Flags   
 case {2, 4, 9},
    sys=[]; 

  %%%%%%%%%%%%%%%%%%%%
  % Unexpected flags %
  %%%%%%%%%%%%%%%%%%%%
  otherwise                                       % Fehlerbehandlung
    error(['Unhandled flag = ',num2str(flag)]);

end

% end pt1sfun

%
%=============================================================================
% mdlInitializeSizes
% Return the sizes, initial conditions, and sample times for the S-function.
%=============================================================================
%
function [sys,x0,str,ts]=mdlInitializeSizes(A,B,C,D)

sizes = simsizes;

sizes.NumContStates  = size(A,1);   % Dimension von A bestimmt Anzahl der
                                    % zeitkontinuierlichen Zustandsvariablen
sizes.NumDiscStates  = 0;           % keine diskreten Zustaende
sizes.NumOutputs     = size(C,1);   % Dimension von C Betsimmt Anzahl der
                                    % Ausgnge
sizes.NumInputs      = size(B,1);   % Dimension von B bestimmt Anzahl der
                                    % Eingnge
sizes.DirFeedthrough = 0;
sizes.NumSampleTimes = 1;           % at least one sample time is needed

sys = simsizes(sizes);

%
% initialize the initial conditions
%
x0  = zeros(size(A,1),1);           % Anfangszustand: x0 = 0

%
% str is always an empty matrix
%
str = [];

%
% initialize the array of sample times; in diesem Beispiel ist die
% Abtastzeit kontinuierlich, daher wird ts und der zugehoerige
% Offset zu Null gesetzt.
%
ts  = [0 0];

% end mdlInitializeSizes

%
%=============================================================================
% mdlDerivatives
% Return the derivatives for the continuous states.
%=============================================================================
%
function sys=mdlDerivatives(t,x,u,A,B,C,D)

sys = A*x + B*u;                     % Berechnung von der Ableitungen xpunkt

% end mdlDerivatives
%%=============================================================================
% mdlOutputs
% Return the block outputs.
%=============================================================================
%
function sys=mdlOutputs(t,x,u,A,B,C,D)

sys = C*x + D*u;                     % Berechnung des Ausgangsvektors y

% end mdlOutputs
