%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% File:         simulink_systems.m
% Description:  Examples of lesson MATLAB/Simulink 
%               Simulink linear & non-linear systems
% Author:       Ulrich Wohlfarth
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% setup

clear all
format compact
echo off
pause on

% Examples of lesson
% Start Simulink 
simulink
pause

% Reset Integrator
bspcontinuous
pause

bspcontinuous1
pause

bspcontinuous2
pause

% Linearisation of Simulink-Models
bsplinmod
pause

[A,B,C,D] = linmod('bsplinmod')
pause

[sizes, x0, xstord] = bsplinmod
pause

sys=ss(A,B,C,D)
tf(sys)
zpk(sys)

% Trim Point 
x0=[1;1;1]
u0=3
[x,u,y,dx] = trim('bsptrim', x0,u0)
pause

% Nonlinear
% Example Quantizer
bspquantizer
bspquantizer_plot_e
pause

% Example Backlash
bspbacklash
bspbacklash_plot_e
pause

% Look-Up Table
% Examples  
bsplookuptable
bsplookuptable_ma_e
pause

% Algebraic loops 
% Example (Inital Guess non-equal to 0) 
bspalgloop
pause

% S-Functions
% Example (PT1 - First order ODE) 
pt1fun
edit pt1fun
pause



























a
