import sys
import webbrowser
import signal
import os
import logging

root_logger = logging.getLogger("it-sec")
fh = logging.FileHandler(os.path.join(os.path.abspath(
    os.path.dirname(__file__)), "it-sec.log"))
fh.setFormatter(logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s'))
root_logger.addHandler(fh)
root_logger.setLevel(logging.DEBUG)

logging.getLogger("it-sec.main").info("started main as root: %s", os.getuid() == 0)


if sys.version_info >= (3,):
    from http.server import HTTPServer
else:
    from SocketServer import TCPServer as HTTPServer


import api  # noqa

signal.signal(signal.SIGINT, lambda sig, frame: sys.exit(0))
os.chdir(os.path.join(os.path.abspath(os.path.dirname(__file__)), "static"))

webbrowser.open_new_tab("http://localhost:8080")
HTTPServer(("0.0.0.0", 8080), api.APIHandler).serve_forever()
