import checker
import json
import os
import sys
import socket
import time
import logging


if sys.version_info >= (3,):
    from http.server import SimpleHTTPRequestHandler
else:
    from SimpleHTTPServer import SimpleHTTPRequestHandler


logger = logging.getLogger("it-sec.api")


class APIHandler(SimpleHTTPRequestHandler):
    def do_GET(self):
        logger.info("GET: %s", self.path)

        if not self.path.startswith("/api/"):
            return SimpleHTTPRequestHandler.do_GET(self)

        if self.path != "/api/settings":
            self.send_error(404)
            return

        self.send_response(200)
        self.end_headers()
        self.wfile.write('{{"hostname":"{}","rules":['.format(
            socket.gethostname()).encode("utf8"))

        first = True

        for i in checker.check():
            if first:
                first = False
            else:
                self.wfile.write(b",")

            self.wfile.write(json.dumps(i).encode("utf8"))

        self.wfile.write(b"]}\n")

    def do_POST(self):
        logger.info("POST: %s", self.path)

        if self.path != "/api/fix":
            self.send_error(404)
            return

        refs = json.loads(self.rfile.read(
            int(self.headers.get("Content-Length"))).decode("utf8"))

        self.send_response(200)
        self.send_header("Transfer-Encoding", "chunked")
        self.end_headers()

        def stream(payload):
            payload = json.dumps(payload)
            self.wfile.write("{:x}\r\n".format(
                len(payload) + 1).encode("utf8"))
            self.wfile.write(payload.encode("utf8"))
            self.wfile.write(b";\r\n")
            self.wfile.flush()

        i = 0

        stream({"progress": 0})

        for err in checker.fix(refs):
            i += 1
            stream({"progress": int(i / len(refs) * 100), "error": err})

        stream({"progress": 100})
        self.wfile.write(b"0\r\n\r\n")
