import React from "react";
import { Checkbox as MCheckbox, Tooltip } from "@material-ui/core";
import { Error as ErrorIcon, CheckBoxOutlineBlank as CheckBoxOutlineBlankIcon } from "@material-ui/icons";

function Checkbox({ item, selected, setSelected }) {
	const anySubSelected = React.useCallback(x => {
		if (x.hasOwnProperty("children")) {
			for (let i of x.children) {
				if (anySubSelected(i)) {
					return true;
				}
			}
		}

		return selected.has(x.ref);
	}, [selected]);
	const allChildrenSelected = React.useCallback(x => {
		if (x.hasOwnProperty("children")) {
			for (let i of x.children) {
				if (!allChildrenSelected(i)) {
					return false;
				}
			}

			return true;
		}

		return x.status === "success" || selected.has(x.ref);
	}, [selected]);
	const onChange = React.useCallback(event => {
		const tmp = new Set([...selected]);
		const rec = func => y => {
			if (y.hasOwnProperty("children")) {
				for (let i of y.children) {
					rec(func)(i);
				}
			} else if (y.status !== "success") {
				func(y.ref);
			}
		};

		// select all
		if (event.target.checked) {
			rec(tmp.add.bind(tmp))(item);
		} else {
			rec(tmp.delete.bind(tmp))(item);
		}

		setSelected(tmp);
	}, [selected, setSelected, item]);

	return (
		<Tooltip title={item.fixable ?
			"Click here to stage this rule for fixing." :
			"This rule is not fixable. Run the program as root or read the manual."}>
			<div>
				<MCheckbox
					disabled={item.status === "success" || !item.fixable}
					indeterminate={anySubSelected(item) && !allChildrenSelected(item)}
					checked={anySubSelected(item)}
					icon={!item.fixable && item.status !== "success" ? <ErrorIcon /> : <CheckBoxOutlineBlankIcon />}
					onChange={onChange} />
			</div>
		</Tooltip>
	);
}

export default Checkbox;
