import React from "react";
import { Dialog, DialogTitle, DialogContent, DialogActions, Button } from "@material-ui/core";

function ConfirmDialog({ children, open, onCancel, onConfirm }) {
	return (
		<Dialog open={open}>
			<DialogTitle>Confirm Action</DialogTitle>
			<DialogContent>{children}</DialogContent>
			<DialogActions>
				<Button onClick={onCancel} color="secondary">Cancel</Button>
				<Button onClick={onConfirm} color="primary">Confirm</Button>
			</DialogActions>
		</Dialog>
	);
}

export default ConfirmDialog;
