import React from "react";
import { withStyles, Backdrop, Typography, Paper, TableContainer, Table, TableHead, TableRow, TableCell, TableBody } from "@material-ui/core";
import { SpeedDial, SpeedDialIcon, SpeedDialAction } from "@material-ui/lab";
import { Save, Update, SelectAll, CheckBoxOutlineBlankOutlined, FullscreenExit, Fullscreen } from "@material-ui/icons";

const styles = theme => ({
	root: {
		zIndex: 22
	},
	speedDial: {
		position: "absolute",
		bottom: theme.spacing(4),
		right: theme.spacing(4),
		whiteSpace: "pre"
	},
	infoBox: {
		position: "absolute",
		top: theme.spacing(4),
		left: theme.spacing(4),
		padding: theme.spacing(2)
	}
});

function QuickActions({ classes, onSelectIssues, onClearSelection, onSave, onFix, onExpandAll, onCollapseAll, hostname, warningCounts }) {
	const [open, setOpen] = React.useState(false);

	return (
		<div className={classes.root}>
			{
				open ?
					<Paper className={classes.infoBox}>
						<Typography variant="h4" color="textSecondary">
							System Summary for <i>{hostname}</i>
						</Typography>

						<TableContainer>
							<Table variant="small">
								<TableHead>
									<TableRow>
										<TableCell>Type</TableCell>
										<TableCell>Count</TableCell>
									</TableRow>
								</TableHead>
								<TableBody>
									{
										Object.keys(warningCounts).map((x, i) =>
											<TableRow key={i}>
												<TableCell>{x}</TableCell>
												<TableCell>{warningCounts[x]}</TableCell>
											</TableRow>
										)
									}
								</TableBody>
							</Table>
						</TableContainer>
					</Paper>
					: null
			}
			<Backdrop open={open} />
			<SpeedDial
				ariaLabel="Quick Actions"
				className={classes.speedDial}
				open={open}
				onOpen={() => setOpen(true)}
				onClose={() => setOpen(false)}
				icon={<SpeedDialIcon />}>
				<SpeedDialAction
					tooltipOpen
					onClick={onCollapseAll}
					tooltipTitle="Collapse All"
					icon={<FullscreenExit />} />
				<SpeedDialAction
					tooltipOpen
					onClick={onExpandAll}
					tooltipTitle="Expand All"
					icon={<Fullscreen />} />
				<SpeedDialAction
					tooltipOpen
					onClick={onSave}
					tooltipTitle="Save"
					icon={<Save />} />
				<SpeedDialAction
					tooltipOpen
					onClick={onFix}
					tooltipTitle="Fix Issues"
					icon={<Update />} />
				<SpeedDialAction
					tooltipOpen
					onClick={onClearSelection}
					tooltipTitle="Clear Selection"
					icon={<CheckBoxOutlineBlankOutlined />} />
				<SpeedDialAction
					tooltipOpen
					onClick={onSelectIssues}
					tooltipTitle="Select All"
					icon={<SelectAll />} />
			</SpeedDial>
		</div>
	);
}

export default withStyles(styles)(QuickActions);