import React from 'react';
import { List, ListItem, ListItemText, ListItemIcon, Collapse, withStyles, IconButton, Tooltip } from "@material-ui/core";
import { Warning, ExpandMore, ExpandLess, Check } from "@material-ui/icons";
import Checkbox from "./Checkbox";

const styles = theme => ({
	nested: {
		paddingLeft: theme.spacing(4)
	},
	green: {
		color: "#80ff00"
	}
});

function RuleDisplay({ classes, rules, selected, setSelected, expanded, onExpandToggle }) {
	const countErrors = x => {
		if (x.hasOwnProperty("children")) {
			let sum = 0;

			for (let i of x.children) {
				sum += countErrors(i);
			}

			return sum;
		}

		return x.status === "success" ? 0 : 1;
	};

	const maker = x => (
		<div key={x.ref}>
			<ListItem>
				<ListItemIcon>
					<Checkbox
						item={x}
						selected={selected}
						setSelected={setSelected} />
				</ListItemIcon>

				{
					x.description ?
						(
							<Tooltip title={x.description} placement="bottom-start">
								<ListItemText primary={x.name} />
							</Tooltip>
						) :
						<ListItemText primary={x.name} />
				}

				<ListItemIcon edge="end">
					{
						x.status === "success" ?
							<Check className={classes.green} /> :
							<Tooltip title={`${countErrors(x)} Warnings`}>
								<Warning color="error" />
							</Tooltip>
					}
				</ListItemIcon>

				{
					x.children ?
						(
							<IconButton onClick={() => onExpandToggle(x)}>
								{expanded.has(x.ref) ? <ExpandLess /> : <ExpandMore />}
							</IconButton>
						) :
						<div />
				}
			</ListItem>

			{
				x.children ? (
					<Collapse in={expanded.has(x.ref)} className={classes.nested}>
						<List component="div" disablePadding>
							{x.children.map(maker)}
						</List>
					</Collapse>
				) : <div />
			}
		</div >
	);

	return (
		<List className={classes.root}>
			{rules.map(maker)}
		</List>
	);
}

export default withStyles(styles)(RuleDisplay);
