import React from 'react';
import ReactDOM from 'react-dom';
import App from './App';
import * as serviceWorker from './serviceWorker';
import { ThemeProvider, createMuiTheme } from "@material-ui/core";
import { SnackbarProvider } from "notistack";

const theme = createMuiTheme({
	palette: {
		type: "dark"
	}
});

ReactDOM.render(
	<React.Fragment>
		<ThemeProvider theme={theme}>
			<SnackbarProvider
				maxSnack={20}
				anchorOrigin={{
					vertical: 'top',
					horizontal: 'right',
				}}>
				<App />
			</SnackbarProvider>
		</ThemeProvider>
	</React.Fragment>,
	document.getElementById('root')
);

// If you want your app to work offline and load faster, you can change
// unregister() to register() below. Note this comes with some pitfalls.
// Learn more about service workers: https://bit.ly/CRA-PWA
serviceWorker.unregister();
