
function makeTable(rules, document) {
	const table = document.createElement("table");

	{
		const tr = document.createElement("tr");

		let th = document.createElement("th");
		th.innerText = "Ref";
		tr.appendChild(th);

		th = document.createElement("th");
		th.innerText = "Name";
		tr.appendChild(th);

		th = document.createElement("th");
		th.innerText = "Status";
		tr.appendChild(th);

		table.appendChild(tr);
	}

	const rec = x => {
		const tr = document.createElement("tr");

		let td = document.createElement("td");
		td.innerText = x.ref;
		tr.appendChild(td);

		td = document.createElement("td");
		td.innerText = x.name;
		tr.appendChild(td);

		td = document.createElement("td");
		td.innerText = x.status;
		tr.appendChild(td);

		table.append(tr);

		for (let i of x.children || []) {
			rec(i);
		}
	};

	for (let i of rules) {
		rec(i);
	}

	return table;
};

export default function (rules) {
	const doc = document.implementation.createHTMLDocument("IT-Security Summary");

	doc.body.appendChild(makeTable(rules, doc));

	const a = document.createElement("a");

	a.href = URL.createObjectURL(new Blob([doc.documentElement.innerHTML], { "type": "text/html" }));
	a.download = "untitled";
	a.click();
};