##################################################################################### 
############################## 
 #Greek EP Election 2009 - Seat allocation using HQ3-EL
 
##################################################################################### 
############################## 
 #Explanation: a<-3 means that the variable `a' is assigned value `3' 
 # sum(v)=v_1_v_2...v_27 
 # floor(8.8)=8, hence the number without fraction 
 
 
 #votes cast for 27 candidating parties 
 v<-c(1878982, 1655722, 428282, 366637, 240930, 178987, 
 65176, 64796, 38899, 33245, 31195, 23564, 21951, 19657, 13146, 10561, 
 7963, 7914, 6484, 6220, 6051, 5622, 4530, 4348, 3104, 2808, 763) 
 
 #Number of Greek seats in European Parliament 
 h<-22 
 
 ####################### 
 #1st step: 
 ####################### 
 HQ1<-floor(sum(v)/h) #number without fraction of all votes summed up divided by 
number of seats 
 
 HQ1 #This number is called `modified Hare Quota' 

 x<-v/HQ1 
 
 s<-floor(x) 
 s #seat allocation in 1st step 

 
 r_1<-h-sum(s) 
 r_1 #seats that remain to be allocated after the 1st step 

 
 ####################### 
 #2nd step 
 ####################### 
 
 u<-v-(HQ1*s) 
 u #this is the `unused electoral power ' 
  DQ1<-floor(sum(u)/(r_11)) 
 DQ1 #this number is called `modified Droop Quota' 
 
 for(i in 1:27){ #This step is needed such that no party that has less in 3% of 
#votes are assigned any seats 
 if (v[i]<sum(v)*3/100){ 
 u[i]<-0} 
 } 
 t<-floor(u/DQ1) 
 t #additional seat allocation in 2nd step 
 s<-t+s 
 s #seat allocation after 2nd step 
 
 
 r_2<-h-sum(s) 
 r_2 #seats that remain to be allocated after the 2nd step 
  
 
 ####################### 
 #3rd step 
 ####################### 
 for(i in 1:27){ 
 if (t[i]!=0){u[i]<-0} 
 } 
 
 s[order(u,decreasing=TRUE)[1:r_2]]<-s[order(u,decreasing=TRUE)[1:r_2]]+1 
 s #r_2 seats are assigned to parties with highest unused electoral power, 
    #not considering parties that were granted seats by 2nd step